/*
 * Decompiled with CFR 0.152.
 */
package samyedit;

import gui.ErrorMessage;
import gui.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.TreeMap;
import samyedit.AirCableChannel;
import samyedit.Channel;
import samyedit.CloneChannel;
import samyedit.SatChannel;

public class MapParser {
    public MapParser(String path, TreeMap<Integer, Channel> channelList) {
        File file = new File(path);
        if ((int)file.length() % 248000 == 0) {
            Main.mapType = 1;
            MapParser.parseAirCable(path, channelList);
            Main.table.setRedraw(false);
            Main.deleteColumns();
            if (Main.mapType == 2) {
                Main.createColumnsAir();
            } else {
                Main.createColumnsCable();
            }
            Main.table.setRedraw(true);
        } else if ((int)file.length() % 144000 == 0) {
            Main.mapType = (byte)4;
            this.parseSat(path, channelList);
            Main.table.setRedraw(false);
            Main.deleteColumns();
            Main.createColumnsSat();
            Main.table.setRedraw(true);
        } else if ((int)file.length() == 115712) {
            Main.mapType = (byte)8;
            this.parseClone(path, channelList);
            Main.table.setRedraw(false);
            Main.deleteColumns();
            Main.createColumnsClone();
            Main.table.setRedraw(true);
        } else {
            new ErrorMessage("File length does not match map-AirD, map-CableD or map-SateD.");
            Main.statusLabel.setText("");
            return;
        }
    }

    public static void parseAirCable(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int size = rawData.length / 248;
        int i = 0;
        while (i < size) {
            int offset = i * 248;
            if (rawData[offset] != 0 && (rawData[offset + 8] & 0xFFFFFF80) != 0) {
                AirCableChannel chan = new AirCableChannel();
                int j = 0;
                while (j < 248) {
                    chan.rawData[j] = rawData[offset + j];
                    ++j;
                }
                chan.num = MapParser.convertEndianess(rawData[offset], rawData[offset + 1]);
                chan.vpid = MapParser.convertEndianess(rawData[offset + 2], rawData[offset + 3]);
                chan.mpid = MapParser.convertEndianess(rawData[offset + 4], rawData[offset + 5]);
                chan.fav = rawData[offset + 6];
                chan.qam = rawData[offset + 7];
                chan.status = rawData[offset + 8];
                chan.stype = rawData[offset + 9];
                chan.sid = MapParser.convertEndianess(rawData[offset + 10], rawData[offset + 11]);
                chan.onid = MapParser.convertEndianess(rawData[offset + 12], rawData[offset + 13]);
                chan.nid = MapParser.convertEndianess(rawData[offset + 14], rawData[offset + 15]);
                chan.enc = rawData[offset + 23];
                chan.freq = MapParser.convertEndianess(rawData[offset + 26], rawData[offset + 27]);
                chan.lcn = MapParser.convertEndianess(rawData[offset + 28], rawData[offset + 29]);
                chan.symbr = MapParser.convertEndianess(rawData[offset + 32], rawData[offset + 33]);
                chan.bouqet = MapParser.convertEndianess(rawData[offset + 34], rawData[offset + 35]);
                chan.tsid = MapParser.convertEndianess(rawData[offset + 36], rawData[offset + 37]);
                chan.lock = rawData[offset + 245];
                chan.fav79 = rawData[offset + 246];
                if (i == 0) {
                    Main.mapType = chan.symbr != 0 ? (byte)1 : (byte)2;
                }
                j = 0;
                while (j < 100) {
                    int c = rawData[offset + 45 + j * 2];
                    if (c == 0) break;
                    if (c < 0) {
                        c += 256;
                    }
                    chan.name = String.valueOf(chan.name) + (char)c;
                    ++j;
                }
                channelList.put(chan.num, chan);
            }
            ++i;
        }
    }

    private void parseSat(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Main.mapType = (byte)4;
        int size = rawData.length / 144;
        int i = 0;
        while (i < size) {
            if (rawData[i * 144] != 0) {
                int offset = i * 144;
                SatChannel chan = new SatChannel();
                int j = 0;
                while (j < 144) {
                    chan.rawData[j] = rawData[offset + j];
                    ++j;
                }
                chan.num = MapParser.convertEndianess(rawData[offset], rawData[offset + 1]);
                chan.vpid = MapParser.convertEndianess(rawData[offset + 2], rawData[offset + 3]);
                chan.mpid = MapParser.convertEndianess(rawData[offset + 4], rawData[offset + 5]);
                chan.vtype = rawData[offset + 6];
                chan.stype = rawData[offset + 14];
                chan.sid = MapParser.convertEndianess(rawData[offset + 16], rawData[offset + 17]);
                chan.tpid = MapParser.convertEndianess(rawData[offset + 18], rawData[offset + 19]);
                chan.sat = MapParser.convertEndianess(rawData[offset + 20], rawData[offset + 21]);
                chan.tsid = MapParser.convertEndianess(rawData[offset + 24], rawData[offset + 25]);
                chan.onid = MapParser.convertEndianess(rawData[offset + 28], rawData[offset + 29]);
                chan.bouqet = MapParser.convertEndianess(rawData[offset + 138], rawData[offset + 139]);
                chan.lock = rawData[offset + 141];
                chan.fav79 = rawData[offset + 142];
                j = 0;
                while (j < 50) {
                    int c = rawData[offset + 37 + j * 2];
                    if (c == 0) break;
                    if (c < 0) {
                        c += 256;
                    }
                    chan.name = String.valueOf(chan.name) + (char)c;
                    ++j;
                }
                channelList.put(chan.num, chan);
            }
            ++i;
        }
    }

    private void parseClone(String path, TreeMap<Integer, Channel> channelList) {
        byte[] rawData;
        try {
            rawData = MapParser.getFileContentsAsBytes(path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Main.mapType = (byte)8;
        Main.rawData = rawData;
        int size = MapParser.convertEndianess(rawData[92658], rawData[92657]);
        int i = 0;
        while (i < size) {
            int offset = 4930 + i * 81;
            System.out.println(rawData[offset + 73]);
            if ((rawData[offset + 73] & 0x20) != 32) {
                CloneChannel chan = new CloneChannel();
                int j = 0;
                while (j < 81) {
                    chan.rawData[j] = rawData[offset + j];
                    ++j;
                }
                j = 0;
                while (j < 50) {
                    int c = rawData[offset + j];
                    if (c == 0) break;
                    if (c < 0) {
                        c += 256;
                    }
                    chan.name = String.valueOf(chan.name) + (char)c;
                    ++j;
                }
                chan.num = MapParser.convertEndianess(rawData[offset + 51], rawData[offset + 50]);
                chan.vpid = MapParser.convertEndianess(rawData[offset + 53], rawData[offset + 52]);
                chan.mpid = MapParser.convertEndianess(rawData[offset + 55], rawData[offset + 54]);
                chan.freq = rawData[offset + 56];
                chan.fav = rawData[offset + 57];
                chan.nid = MapParser.convertEndianess(rawData[offset + 60], rawData[offset + 59]);
                chan.tsid = MapParser.convertEndianess(rawData[offset + 62], rawData[offset + 61]);
                chan.onid = MapParser.convertEndianess(rawData[offset + 64], rawData[offset + 63]);
                chan.sid = MapParser.convertEndianess(rawData[offset + 66], rawData[offset + 65]);
                chan.stype = rawData[offset + 71];
                chan.enc = rawData[offset + 73];
                channelList.put(chan.num, chan);
            }
            ++i;
        }
    }

    public static void write(String file, TreeMap<Integer, Channel> channelList) {
        switch (Main.mapType) {
            case 1: 
            case 2: {
                MapParser.writeAirCable(file, channelList);
                break;
            }
            case 4: {
                MapParser.writeSat(file, channelList);
                break;
            }
            case 8: {
                MapParser.writeClone(file, channelList);
            }
        }
    }

    public static void writeClone(String file, TreeMap<Integer, Channel> channelList) {
        FileOutputStream outStream;
        Iterator<Channel> it = channelList.values().iterator();
        File f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        try {
            ((OutputStream)outStream).write(Main.rawData, 0, 4930);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        int entries = 0;
        while (it.hasNext() && entries < 999) {
            CloneChannel chan = (CloneChannel)it.next();
            byte[] rawData = chan.rawData;
            char[] name = chan.name.toCharArray();
            int n = 0;
            while (n < name.length && n < 50) {
                rawData[n] = (byte)name[n];
                ++n;
            }
            rawData[75] = (byte)n;
            while (n < 50) {
                rawData[n] = 0;
                ++n;
            }
            MapParser.revertClone(rawData, 50, chan.num);
            MapParser.revertClone(rawData, 52, chan.vpid);
            MapParser.revertClone(rawData, 54, chan.mpid);
            rawData[56] = (byte)chan.freq;
            rawData[57] = chan.fav;
            MapParser.revertClone(rawData, 59, chan.nid);
            MapParser.revertClone(rawData, 61, chan.tsid);
            MapParser.revertClone(rawData, 63, chan.onid);
            MapParser.revertClone(rawData, 65, chan.sid);
            rawData[71] = chan.stype;
            rawData[73] = chan.enc;
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        System.out.println(entries);
        MapParser.revertClone(Main.rawData, 92654, entries);
        MapParser.revertClone(Main.rawData, 92657, entries);
        byte[] rawData = new byte[81];
        int i = 0;
        while (i < 81) {
            rawData[i] = -1;
            ++i;
        }
        while (entries < 999) {
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        try {
            ((OutputStream)outStream).write(Main.rawData, 85849, 29863);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    public static void writeAirCable(String file, TreeMap<Integer, Channel> channelList) {
        FileOutputStream outStream;
        Iterator<Channel> it = channelList.values().iterator();
        File f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        int entries = 0;
        while (it.hasNext()) {
            AirCableChannel chan = (AirCableChannel)it.next();
            byte[] rawData = chan.rawData;
            MapParser.revertEndianess(rawData, 0, chan.num);
            MapParser.revertEndianess(rawData, 2, chan.vpid);
            MapParser.revertEndianess(rawData, 4, chan.mpid);
            rawData[6] = chan.fav;
            rawData[7] = chan.qam;
            rawData[8] = chan.status;
            rawData[9] = chan.stype;
            MapParser.revertEndianess(rawData, 10, chan.sid);
            MapParser.revertEndianess(rawData, 12, chan.onid);
            MapParser.revertEndianess(rawData, 14, chan.nid);
            rawData[23] = chan.enc;
            MapParser.revertEndianess(rawData, 26, chan.freq);
            MapParser.revertEndianess(rawData, 32, chan.symbr);
            MapParser.revertEndianess(rawData, 34, chan.bouqet);
            MapParser.revertEndianess(rawData, 36, chan.tsid);
            char[] name = chan.name.toCharArray();
            int n = 0;
            while (n < name.length) {
                rawData[45 + 2 * n] = (byte)name[n];
                ++n;
            }
            while (n < 100) {
                rawData[45 + 2 * n] = 0;
                ++n;
            }
            rawData[245] = chan.lock;
            rawData[246] = chan.fav79;
            rawData[247] = 0;
            int i = 0;
            while (i < 247) {
                rawData[247] = (byte)(rawData[247] + rawData[i]);
                ++i;
            }
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        while (entries % 1000 != 0) {
            byte[] rawData = new byte[248];
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    public static void writeSat(String file, TreeMap<Integer, Channel> channelList) {
        FileOutputStream outStream;
        Iterator<Channel> it = channelList.values().iterator();
        File f = new File(file);
        try {
            outStream = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            new ErrorMessage("Cannot write to file:\n" + e.getMessage());
            Main.statusLabel.setText("");
            return;
        }
        int entries = 0;
        while (it.hasNext()) {
            SatChannel chan = (SatChannel)it.next();
            byte[] rawData = chan.rawData;
            MapParser.revertEndianess(rawData, 0, chan.num);
            MapParser.revertEndianess(rawData, 2, chan.vpid);
            MapParser.revertEndianess(rawData, 4, chan.mpid);
            rawData[6] = chan.vtype;
            rawData[14] = chan.stype;
            MapParser.revertEndianess(rawData, 16, chan.sid);
            MapParser.revertEndianess(rawData, 18, chan.tpid);
            MapParser.revertEndianess(rawData, 20, chan.sat);
            MapParser.revertEndianess(rawData, 24, chan.tsid);
            MapParser.revertEndianess(rawData, 28, chan.onid);
            char[] name = chan.name.toCharArray();
            int n = 0;
            while (n < name.length) {
                rawData[37 + 2 * n] = (byte)name[n];
                ++n;
            }
            while (n < 50) {
                rawData[37 + 2 * n] = 0;
                ++n;
            }
            MapParser.revertEndianess(rawData, 138, chan.bouqet);
            rawData[141] = chan.lock;
            rawData[142] = chan.fav79;
            rawData[143] = 0;
            int i = 0;
            while (i < 143) {
                rawData[143] = (byte)(rawData[143] + rawData[i]);
                ++i;
            }
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        while (entries % 1000 != 0) {
            byte[] rawData = new byte[144];
            try {
                ((OutputStream)outStream).write(rawData);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            ++entries;
        }
        Main.statusLabel.setText("Channel list written to file: " + file);
    }

    private static int convertEndianess(byte b, byte c) {
        int lower = b;
        int upper = c;
        if (b < 0) {
            lower += 256;
        }
        if (c < 0) {
            upper += 256;
        }
        return lower + (upper << 8);
    }

    private static void revertEndianess(byte[] b, int offset, int data) {
        b[offset] = (byte)data;
        b[offset + 1] = (byte)(data >> 8);
    }

    private static void revertClone(byte[] b, int offset, int data) {
        b[offset + 1] = (byte)data;
        b[offset] = (byte)(data >> 8);
    }

    private static byte[] getFileContentsAsBytes(String file) throws IOException {
        File f = new File(file);
        byte[] data = new byte[(int)f.length()];
        FileInputStream inStream = new FileInputStream(f);
        ((InputStream)inStream).read(data);
        ((InputStream)inStream).close();
        return data;
    }
}

