/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.About;
import gui.Edit;
import gui.Find;
import gui.Main;
import gui.Move;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import samyedit.AirCableChannel;
import samyedit.AirChannel;
import samyedit.Channel;
import samyedit.MapParser;
import samyedit.SatChannel;
import samyedit.SkyFeedChannels;

class MySelListener
implements SelectionListener {
    public static final int ACTION_NEWAIR = 0;
    public static final int ACTION_NEWCABLE = 1;
    public static final int ACTION_NEWSAT = 2;
    public static final int ACTION_OPEN = 3;
    public static final int ACTION_SAVE = 4;
    public static final int ACTION_SAVEAS = 5;
    public static final int ACTION_ADDCHAN = 6;
    public static final int ACTION_EDITCHAN = 7;
    public static final int ACTION_MOVECHAN = 8;
    public static final int ACTION_DELETE = 9;
    public static final int ACTION_FINDCHAN = 10;
    public static final int ACTION_FAVADD = 11;
    public static final int ACTION_FAVDEL = 12;
    public static final int ACTION_LOCKADD = 13;
    public static final int ACTION_LOCKDEL = 14;
    public static final int ACTION_SKY = 15;
    public static final int ACTION_FAV79_1 = 64;
    public static final int ACTION_FAV79_2 = 65;
    public static final int ACTION_FAV79_3 = 66;
    public static final int ACTION_FAV79_4 = 67;
    public static final int ACTION_WWW = 128;
    public static final int ACTION_ABOUT = 129;
    private Shell shell;

    MySelListener(Shell shell) {
        this.shell = shell;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof MenuItem) {
            int action = (Integer)e.widget.getData("action");
            switch (action) {
                case 0: {
                    Main.mapType = (byte)2;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsAir();
                    break;
                }
                case 1: {
                    Main.mapType = 1;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsCable();
                    break;
                }
                case 2: {
                    Main.mapType = (byte)4;
                    Main.channelList.clear();
                    Main.refresh();
                    Main.deleteColumns();
                    Main.createColumnsSat();
                    break;
                }
                case 3: {
                    FileDialog fd = new FileDialog(this.shell, 4096);
                    fd.setText("Open");
                    String path = fd.open();
                    if (path == null) {
                        return;
                    }
                    Main.channelList.clear();
                    System.gc();
                    new MapParser(path, Main.channelList);
                    Main.refresh();
                    Main.filepath = path;
                    Main.statusLabel.setText("Finished opening file: " + Main.filepath);
                    return;
                }
                case 4: {
                    if (Main.filepath == null) {
                        FileDialog fsd = new FileDialog(this.shell, 8192);
                        fsd.setText("Save");
                        String spath = fsd.open();
                        if (spath == null) {
                            return;
                        }
                        MapParser.write(spath, Main.channelList);
                        Main.filepath = spath;
                    } else {
                        MapParser.write(Main.filepath, Main.channelList);
                    }
                    return;
                }
                case 5: {
                    FileDialog fsd = new FileDialog(this.shell, 8192);
                    fsd.setText("Save");
                    String[] filtersExt = new String[]{"*.*"};
                    fsd.setFilterExtensions(filtersExt);
                    String spath = fsd.open();
                    if (spath == null) {
                        return;
                    }
                    MapParser.write(spath, Main.channelList);
                    Main.filepath = spath;
                    return;
                }
                case 6: {
                    switch (Main.mapType) {
                        case 1: {
                            new Edit(new AirCableChannel());
                            break;
                        }
                        case 2: {
                            new Edit(new AirChannel());
                            break;
                        }
                        case 4: {
                            new Edit(new SatChannel());
                        }
                    }
                    return;
                }
                case 7: {
                    TableItem[] item = Main.table.getSelection();
                    if (item.length > 0) {
                        new Edit((Channel)item[0].getData());
                    }
                    return;
                }
                case 8: {
                    if (Main.getSelected().length == 0) {
                        return;
                    }
                    new Move();
                    return;
                }
                case 9: {
                    Main.deleteChannels(Main.getSelected());
                    Main.refresh(false);
                    return;
                }
                case 10: {
                    new Find();
                    return;
                }
                case 11: {
                    Channel[] addfav = Main.getSelected();
                    int i = 0;
                    while (i < addfav.length) {
                        addfav[i].fav = (byte)(addfav[i].fav | 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 12: {
                    Channel[] delfav = Main.getSelected();
                    int i = 0;
                    while (i < delfav.length) {
                        delfav[i].fav = (byte)(delfav[i].fav & 0xFFFFFFFE);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 13: {
                    Channel[] addlock = Main.getSelected();
                    int i = 0;
                    while (i < addlock.length) {
                        addlock[i].lock = (byte)(addlock[i].lock | 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 14: {
                    Channel[] dellock = Main.getSelected();
                    int i = 0;
                    while (i < dellock.length) {
                        dellock[i].lock = (byte)(dellock[i].lock & 0xFFFFFFFE);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 15: {
                    SkyFeedChannels.add(Main.channelList);
                    Main.refresh();
                    return;
                }
                case 64: {
                    Channel[] fav791 = Main.getSelected();
                    int i = 0;
                    while (i < fav791.length) {
                        fav791[i].fav79 = (byte)(fav791[i].fav79 ^ 1);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 65: {
                    Channel[] fav792 = Main.getSelected();
                    int i = 0;
                    while (i < fav792.length) {
                        fav792[i].fav79 = (byte)(fav792[i].fav79 ^ 2);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 66: {
                    Channel[] fav793 = Main.getSelected();
                    int i = 0;
                    while (i < fav793.length) {
                        fav793[i].fav79 = (byte)(fav793[i].fav79 ^ 4);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 67: {
                    Channel[] fav794 = Main.getSelected();
                    int i = 0;
                    while (i < fav794.length) {
                        fav794[i].fav79 = (byte)(fav794[i].fav79 ^ 8);
                        ++i;
                    }
                    Main.refresh();
                    return;
                }
                case 128: {
                    try {
                        Desktop.getDesktop().browse(new URI("http://www.polskafan.de/samsung/documentation"));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    catch (URISyntaxException ex) {
                        ex.printStackTrace();
                    }
                    return;
                }
                case 129: {
                    new About();
                    return;
                }
                default: {
                    return;
                }
            }
        }
    }
}

