/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Edit;
import gui.Exit;
import gui.MyListener;
import gui.MySelListener;
import gui.SortListenerFactory;
import java.util.Iterator;
import java.util.TreeMap;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import samyedit.AirCableChannel;
import samyedit.Channel;
import samyedit.CloneChannel;
import samyedit.MapParser;
import samyedit.SatChannel;

public class Main {
    static Display display;
    static Shell shell;
    public static Table table;
    public static Label statusLabel;
    public static Label modeLabel;
    public static byte mapType;
    public static byte[] rawData;
    static TreeMap<Integer, Channel> channelList;
    static String filepath;
    static String version;

    static {
        mapType = 1;
        channelList = new TreeMap();
        version = "v0.42";
    }

    public static void main(String[] args) {
        display = new Display();
        shell = new Shell(display, 1264);
        shell.setSize(820, 500);
        shell.setText("SamyGO Channel Editor " + version);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        shell.setLayout((Layout)layout);
        Main.createMenuBar();
        Main.createTable();
        GridData twoColumn = new GridData(1808);
        twoColumn.horizontalSpan = 2;
        table.setLayoutData((Object)twoColumn);
        statusLabel = new Label((Composite)shell, 2048);
        statusLabel.setText("Ready.");
        statusLabel.setLayoutData((Object)new GridData(768));
        modeLabel = new Label((Composite)shell, 133120);
        modeLabel.setText("Mode: map-CableD");
        modeLabel.setLayoutData((Object)new GridData());
        modeLabel.pack();
        Main.refresh();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static void createMenuBar() {
        Menu mbar = new Menu((Decorations)shell, 2);
        shell.setMenuBar(mbar);
        MyListener myListener = new MyListener();
        MySelListener mySelListener = new MySelListener(shell);
        MenuItem MenuBar = new MenuItem(mbar, 64);
        MenuBar.setText("&File");
        Menu Menu2 = new Menu(MenuBar);
        Menu2.addListener(22, (Listener)myListener);
        MenuBar.setMenu(Menu2);
        MenuItem Item = new MenuItem(Menu2, 64);
        Item.setText("New");
        Menu subMenu = new Menu(Item);
        Item.setMenu(subMenu);
        Item = new MenuItem(subMenu, 0);
        Item.setText("map-AirD");
        Item.setData("action", (Object)0);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(subMenu, 0);
        Item.setText("map-CableD");
        Item.setData("action", (Object)1);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(subMenu, 0);
        Item.setText("map-SateD");
        Item.setData("action", (Object)2);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("&Open...\tCtrl+O");
        Item.setData("action", (Object)3);
        Item.setAccelerator(262223);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("&Save\tCtrl+S");
        Item.setData("action", (Object)4);
        Item.setAccelerator(262227);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Save As...");
        Item.setData("action", (Object)5);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("&Quit");
        Item.addSelectionListener((SelectionListener)new Exit(shell));
        MenuBar = new MenuItem(mbar, 64);
        MenuBar.setText("&Edit");
        Menu2 = new Menu(MenuBar);
        Menu2.addListener(22, (Listener)myListener);
        MenuBar.setMenu(Menu2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Add new Channel...\tCtrl+N");
        Item.setData("action", (Object)6);
        Item.setAccelerator(262222);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Edit Channel...\tCtrl+E");
        Item.setData("action", (Object)7);
        Item.setAccelerator(262213);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Move Channel(s)...\tCtrl+M");
        Item.setData("action", (Object)8);
        Item.setAccelerator(262221);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Delete Channel(s)\tDel");
        Item.setData("action", (Object)9);
        Item.setAccelerator(127);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Find Channel...\tCtrl+F");
        Item.setData("action", (Object)10);
        Item.setAccelerator(262214);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Add to favourites\tCtrl+Up");
        Item.setData("action", (Object)11);
        Item.setAccelerator(0x1040001);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Remove from favourites\tCtrl+Down");
        Item.setData("action", (Object)12);
        Item.setAccelerator(17039362);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Add parental lock\tCtrl+Alt+Up");
        Item.setData("action", (Object)13);
        Item.setAccelerator(0x1050001);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Remove parental lock\tCtrl+Alt+Down");
        Item.setData("action", (Object)14);
        Item.setAccelerator(17104898);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Add Sky.de Feed Channels");
        Item.setData("action", (Object)15);
        Item.addSelectionListener((SelectionListener)mySelListener);
        MenuBar = new MenuItem(mbar, 64);
        MenuBar.setText("&Fav79");
        Menu2 = new Menu(MenuBar);
        Menu2.addListener(22, (Listener)myListener);
        MenuBar.setMenu(Menu2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Toggle List 1\tCtrl+Shift+1");
        Item.setData("action", (Object)64);
        Item.setAccelerator(393265);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Toggle List 2\tCtrl+Shift+2");
        Item.setData("action", (Object)65);
        Item.setAccelerator(393266);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Toggle List 3\tCtrl+Shift+3");
        Item.setData("action", (Object)66);
        Item.setAccelerator(393267);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Toggle List 4\tCtrl+Shift+4");
        Item.setData("action", (Object)67);
        Item.setAccelerator(393268);
        Item.addSelectionListener((SelectionListener)mySelListener);
        MenuBar = new MenuItem(mbar, 64);
        MenuBar.setText("&Help");
        Menu2 = new Menu(MenuBar);
        MenuBar.setMenu(Menu2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("Online Help");
        Item.setData("action", (Object)128);
        Item.addSelectionListener((SelectionListener)mySelListener);
        Item = new MenuItem(Menu2, 2);
        Item = new MenuItem(Menu2, 0);
        Item.setText("About");
        Item.setData("action", (Object)129);
        Item.addSelectionListener((SelectionListener)mySelListener);
    }

    private static void createTable() {
        table = new Table((Composite)shell, 67586);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        Main.createColumnsCable();
        table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                new Edit(Main.getSelected()[0]);
            }

            public void widgetSelected(SelectionEvent arg0) {
            }
        });
        DragSource ds = new DragSource((Control)table, 18);
        ds.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        ds.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent event) {
                DragSource ds = (DragSource)event.widget;
                Table table = (Table)ds.getControl();
                TableItem[] selection = table.getSelection();
                StringBuffer buff = new StringBuffer("channel\n");
                int i = 0;
                int n = selection.length;
                while (i < n) {
                    buff.append(String.valueOf(selection[i].getText()) + "\n");
                    ++i;
                }
                event.data = buff.toString();
            }
        });
        DropTarget dt = new DropTarget((Control)table, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragOver(DropTargetEvent event) {
                event.feedback = 9;
            }

            public void drop(DropTargetEvent event) {
                if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String[] fileList = (String[])event.data;
                    table.removeAll();
                    table.clearAll();
                    channelList.clear();
                    new MapParser(fileList[0], channelList);
                    filepath = fileList[0];
                    statusLabel.setText("Finished opening file: " + filepath);
                    Main.refresh();
                }
                if (TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    String move = (String)event.data;
                    String[] channels = move.split("\n");
                    Channel[] selected = new Channel[channels.length - 1];
                    if (!(event.item instanceof TableItem)) {
                        return;
                    }
                    if (channels[0].equals("channel")) {
                        int i = 1;
                        while (i < channels.length) {
                            selected[i - 1] = channelList.get(new Integer(channels[i]));
                            ++i;
                        }
                    } else {
                        return;
                    }
                    TableItem item = (TableItem)event.item;
                    Channel targetChan = (Channel)item.getData();
                    Main.moveChannels(selected, targetChan);
                    Main.refresh(false);
                }
            }
        });
    }

    public static void createColumnsCable() {
        TableColumn[] col = new TableColumn[15];
        String[] colNames = new String[]{"No.", "Name", "Freq", "SR", "Nid", "Onid", "Tsid", "Sid", "Pid", "Vpid", "Typ", "Fav", "Fav79", "Enc", "Lock"};
        int[] colWidth = new int[]{40, 175, 40, 45, 45, 45, 45, 45, 45, 45, 45, 40, 50, 40, 40};
        int[] colAlign = new int[]{131072, 16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        int text = 1;
        int integer = 0;
        int[] colType = new int[]{integer, text, integer, integer, integer, integer, integer, integer, integer, integer, text, text, text, text, text};
        int c = 0;
        while (c < col.length) {
            col[c] = new TableColumn(table, 0x1000000);
            col[c].setText(colNames[c]);
            col[c].setWidth(colWidth[c]);
            col[c].setAlignment(colAlign[c]);
            col[c].setResizable(true);
            col[c].setData("type", (Object)colType[c]);
            col[c].addListener(13, SortListenerFactory.getListener());
            ++c;
        }
    }

    public static void createColumnsAir() {
        TableColumn[] col = new TableColumn[14];
        String[] colNames = new String[]{"No.", "Name", "Freq", "LCN", "Onid", "Tsid", "Sid", "Pid", "Vpid", "Typ", "Fav", "Fav79", "Enc", "Lock"};
        int[] colWidth = new int[]{40, 175, 40, 40, 45, 45, 45, 45, 45, 45, 40, 50, 40, 40};
        int[] colAlign = new int[]{131072, 16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        int text = 1;
        int integer = 0;
        int[] colType = new int[]{integer, text, integer, integer, integer, integer, integer, integer, integer, text, text, text, text, text};
        int c = 0;
        while (c < col.length) {
            col[c] = new TableColumn(table, 0x1000000);
            col[c].setText(colNames[c]);
            col[c].setWidth(colWidth[c]);
            col[c].setAlignment(colAlign[c]);
            col[c].setResizable(true);
            col[c].setData("type", (Object)colType[c]);
            col[c].addListener(13, SortListenerFactory.getListener());
            ++c;
        }
    }

    public static void createColumnsSat() {
        TableColumn[] col = new TableColumn[12];
        String[] colNames = new String[]{"No.", "Name", "Sat", "TPID", "Onid", "Tsid", "Sid", "Pid", "Vpid", "Typ", "Fav79", "Lock"};
        int[] colWidth = new int[]{40, 175, 45, 45, 45, 45, 45, 45, 45, 45, 50, 40};
        int[] colAlign = new int[]{131072, 16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        int text = 1;
        int integer = 0;
        int[] colType = new int[]{integer, text, integer, integer, integer, integer, integer, integer, integer, text, text, text};
        int c = 0;
        while (c < col.length) {
            col[c] = new TableColumn(table, 0x1000000);
            col[c].setText(colNames[c]);
            col[c].setWidth(colWidth[c]);
            col[c].setAlignment(colAlign[c]);
            col[c].setResizable(true);
            col[c].setData("type", (Object)colType[c]);
            col[c].addListener(13, SortListenerFactory.getListener());
            ++c;
        }
    }

    public static void createColumnsClone() {
        TableColumn[] col = new TableColumn[12];
        String[] colNames = new String[]{"No.", "Name", "Freq", "Nid", "Onid", "Tsid", "Sid", "Pid", "Vpid", "Typ", "Fav", "Enc"};
        int[] colWidth = new int[]{40, 175, 40, 45, 45, 45, 45, 45, 45, 45, 40, 40};
        int[] colAlign = new int[]{131072, 16384, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000, 0x1000000};
        int text = 1;
        int integer = 0;
        int[] colType = new int[]{integer, text, integer, integer, integer, integer, integer, integer, integer, text, text, text};
        int c = 0;
        while (c < col.length) {
            col[c] = new TableColumn(table, 0x1000000);
            col[c].setText(colNames[c]);
            col[c].setWidth(colWidth[c]);
            col[c].setAlignment(colAlign[c]);
            col[c].setResizable(true);
            col[c].setData("type", (Object)colType[c]);
            col[c].addListener(13, SortListenerFactory.getListener());
            ++c;
        }
    }

    public static void deleteColumns() {
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].dispose();
            ++i;
        }
    }

    public static void refresh(boolean select) {
        table.setRedraw(false);
        int[] selected = table.getSelectionIndices();
        int topIndex = table.getTopIndex();
        table.clearAll();
        table.removeAll();
        switch (mapType) {
            case 1: {
                Main.fillCable();
                break;
            }
            case 2: {
                Main.fillAir();
                break;
            }
            case 4: {
                Main.fillSat();
                break;
            }
            case 8: {
                Main.fillClone();
            }
        }
        if (select) {
            table.setSelection(selected);
        }
        table.setRedraw(true);
        table.setTopIndex(topIndex);
    }

    public static void refresh() {
        Main.refresh(true);
    }

    public static void fillCable() {
        modeLabel.setText("Mode: map-CableD");
        for (AirCableChannel airCableChannel : channelList.values()) {
            String typ;
            TableItem t = new TableItem(table, 16384);
            switch (airCableChannel.stype) {
                case 1: {
                    typ = "TV";
                    break;
                }
                case 2: {
                    typ = "Radio";
                    break;
                }
                case 12: {
                    typ = "Data";
                    break;
                }
                case 25: {
                    typ = "HD";
                    break;
                }
                default: {
                    typ = "?";
                }
            }
            String fav = (airCableChannel.fav & 1) != 0 ? "yes" : "no";
            String enc = (airCableChannel.enc & 0x20) != 0 ? "yes" : "no";
            String lock = (airCableChannel.lock & 1) != 0 ? "yes" : "no";
            String fav79 = "";
            if ((airCableChannel.fav79 & 1) == 1) {
                fav79 = String.valueOf(fav79) + "1,";
            }
            if ((airCableChannel.fav79 & 2) == 2) {
                fav79 = String.valueOf(fav79) + "2,";
            }
            if ((airCableChannel.fav79 & 4) == 4) {
                fav79 = String.valueOf(fav79) + "3,";
            }
            if ((airCableChannel.fav79 & 8) == 8) {
                fav79 = String.valueOf(fav79) + "4,";
            }
            if (fav79.length() != 0) {
                fav79 = fav79.substring(0, fav79.length() - 1);
            }
            String[] col = new String[]{String.valueOf(airCableChannel.num), airCableChannel.name, String.valueOf(airCableChannel.freq), String.valueOf(airCableChannel.symbr), String.valueOf(airCableChannel.nid), String.valueOf(airCableChannel.onid), String.valueOf(airCableChannel.tsid), String.valueOf(airCableChannel.sid), String.valueOf(airCableChannel.mpid), String.valueOf(airCableChannel.vpid), typ, fav, fav79, enc, lock};
            t.setText(col);
            t.setData((Object)airCableChannel);
        }
    }

    public static void fillAir() {
        modeLabel.setText("Mode: map-AirD");
        for (AirCableChannel airCableChannel : channelList.values()) {
            String typ;
            TableItem t = new TableItem(table, 16384);
            switch (airCableChannel.stype) {
                case 1: {
                    typ = "TV";
                    break;
                }
                case 2: {
                    typ = "Radio";
                    break;
                }
                case 12: {
                    typ = "Data";
                    break;
                }
                case 25: {
                    typ = "HD";
                    break;
                }
                default: {
                    typ = "?";
                }
            }
            String fav = (airCableChannel.fav & 1) != 0 ? "yes" : "no";
            String enc = (airCableChannel.enc & 0x20) != 0 ? "yes" : "no";
            String lock = (airCableChannel.lock & 1) != 0 ? "yes" : "no";
            String fav79 = "";
            if ((airCableChannel.fav79 & 1) == 1) {
                fav79 = String.valueOf(fav79) + "1,";
            }
            if ((airCableChannel.fav79 & 2) == 2) {
                fav79 = String.valueOf(fav79) + "2,";
            }
            if ((airCableChannel.fav79 & 4) == 4) {
                fav79 = String.valueOf(fav79) + "3,";
            }
            if ((airCableChannel.fav79 & 8) == 8) {
                fav79 = String.valueOf(fav79) + "4,";
            }
            if (fav79.length() != 0) {
                fav79 = fav79.substring(0, fav79.length() - 1);
            }
            String[] col = new String[]{String.valueOf(airCableChannel.num), airCableChannel.name, String.valueOf(airCableChannel.freq), String.valueOf(airCableChannel.lcn), String.valueOf(airCableChannel.onid), String.valueOf(airCableChannel.tsid), String.valueOf(airCableChannel.sid), String.valueOf(airCableChannel.mpid), String.valueOf(airCableChannel.vpid), typ, fav, fav79, enc, lock};
            t.setText(col);
            t.setData((Object)airCableChannel);
        }
    }

    public static void fillSat() {
        modeLabel.setText("Mode: map-SateD");
        for (SatChannel satChannel : channelList.values()) {
            String typ;
            TableItem t = new TableItem(table, 16384);
            switch (satChannel.stype) {
                case 1: {
                    typ = "TV";
                    break;
                }
                case 2: {
                    typ = "Radio";
                    break;
                }
                case 12: {
                    typ = "Data";
                    break;
                }
                case 25: {
                    typ = "HD";
                    break;
                }
                default: {
                    typ = "?";
                }
            }
            String lock = satChannel.lock == 1 ? "yes" : "no";
            String fav79 = "";
            if ((satChannel.fav79 & 1) == 1) {
                fav79 = String.valueOf(fav79) + "1,";
            }
            if ((satChannel.fav79 & 2) == 2) {
                fav79 = String.valueOf(fav79) + "2,";
            }
            if ((satChannel.fav79 & 4) == 4) {
                fav79 = String.valueOf(fav79) + "3,";
            }
            if ((satChannel.fav79 & 8) == 8) {
                fav79 = String.valueOf(fav79) + "4,";
            }
            if (fav79.length() != 0) {
                fav79 = fav79.substring(0, fav79.length() - 1);
            }
            String[] col = new String[]{String.valueOf(satChannel.num), satChannel.name, String.valueOf(satChannel.sat), String.valueOf(satChannel.tpid), String.valueOf(satChannel.onid), String.valueOf(satChannel.tsid), String.valueOf(satChannel.sid), String.valueOf(satChannel.mpid), String.valueOf(satChannel.vpid), typ, fav79, lock};
            t.setText(col);
            t.setData((Object)satChannel);
        }
    }

    public static void fillClone() {
        modeLabel.setText("Mode: CLONE.BIN");
        for (CloneChannel cloneChannel : channelList.values()) {
            String typ;
            TableItem t = new TableItem(table, 16384);
            switch (cloneChannel.stype) {
                case 1: {
                    typ = "TV";
                    break;
                }
                case 2: {
                    typ = "Radio";
                    break;
                }
                case 12: {
                    typ = "Data";
                    break;
                }
                case 25: {
                    typ = "HD";
                    break;
                }
                default: {
                    typ = "? (" + cloneChannel.stype + ")";
                }
            }
            String fav = (cloneChannel.fav & 1) != 0 ? "yes" : "no";
            String enc = (cloneChannel.enc & 4) != 0 ? "yes" : "no";
            String[] col = new String[]{String.valueOf(cloneChannel.num), cloneChannel.name, String.valueOf(cloneChannel.freq), String.valueOf(cloneChannel.nid), String.valueOf(cloneChannel.onid), String.valueOf(cloneChannel.tsid), String.valueOf(cloneChannel.sid), String.valueOf(cloneChannel.mpid), String.valueOf(cloneChannel.vpid), typ, fav, enc};
            t.setText(col);
            t.setData((Object)cloneChannel);
        }
    }

    public static void moveChannels(Channel[] selected, Channel targetChan) {
        int cIndex = targetChan.num;
        Main.deleteChannels(selected);
        TreeMap<Integer, Channel> tailMap = new TreeMap<Integer, Channel>(channelList.tailMap(cIndex));
        Iterator<Channel> it = tailMap.values().iterator();
        while (it.hasNext()) {
            channelList.remove(it.next().num);
        }
        int i = 0;
        while (i < selected.length) {
            selected[i].num = cIndex++;
            channelList.put(selected[i].num, selected[i]);
            ++i;
        }
        for (Channel c : tailMap.values()) {
            if (channelList.containsKey(c.num)) {
                c.num = cIndex++;
                channelList.put(c.num, c);
                continue;
            }
            channelList.put(c.num, c);
        }
    }

    static Channel[] getSelected() {
        TableItem[] items = table.getSelection();
        Channel[] selected = new Channel[items.length];
        int i = 0;
        while (i < items.length) {
            selected[i] = channelList.get(new Integer(items[i].getText()));
            ++i;
        }
        return selected;
    }

    static void deleteChannels(Channel[] selected) {
        int i = 0;
        while (i < selected.length) {
            Channel c;
            channelList.remove(selected[i].num);
            int j = selected[i].num + 1;
            while ((c = channelList.get(j)) != null) {
                channelList.remove(j);
                --c.num;
                channelList.put(c.num, c);
                ++j;
            }
            ++i;
        }
    }
}

